/* @(#) somx/sample5p.cpp 2.3 1/20/94 10:29:01 [5/15/94 17:59:17] */

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */

/*
 *  Persistent Framework Example 5
 */

#include <stdlib.h>
#include <somp.xh>            /*  Persistence Includes   */
#include <direntry.xh>        /*  Client Class Includes  */
#include <phonedir.xh>

/* Global Declarations.
   -------------------- */
SOMPPersistentStorageMgr *psm;
SOMPIdAssigner *idAssigner;
static char idBuff[SOMPMAXIDSIZE]; /*  Stores system Id of persistent object */
Environment *ev;

/*
--------------------------------------------------------------------
save
Demonstrates creating and storing of a compound
persistent object - a list of phone numbers.

Demonstrated Features:
  - system-assigned persistent id.
  - all objects in a single io/group.
  - default attribute encoder/decoder.
  - object modification.
--------------------------------------------------------------------
 */

void save()
{
/* Local declarations.
   ------------------- */
   SOMPPersistentId *pid;
   dirEntry *name1, *name2, *name3;
   phoneDir *mylist;
   string fp;

/* Create phone directory with three entries.
   ------------------------------------------ */
   mylist = new phoneDir;

   name1 = new dirEntry;
   name1->mkEntry ("Roger", "555-5085");
   mylist->addEntry (name1);

   name2 = new dirEntry;
   name2->mkEntry ("Hari", "555-5079");
   mylist->addEntry (name2);

   name3 = new dirEntry;
   name3->mkEntry ("Charles", "555-5571");
   mylist->addEntry (name3);

/* Display phone directory.
   ------------------------ */
   mylist->printDirInfo();

/* Initialize Persistent ID(s).
   ---------------------------- */
   mylist->sompInitNextAvail (ev, idAssigner);    /* System-Assigned */
   if (ev->_major != NO_EXCEPTION) exit(-1);

   name1->sompInitNearObject (ev, mylist);
   if (ev->_major != NO_EXCEPTION) exit(-1);

   name2->sompInitNearObject (ev, mylist);
   if (ev->_major != NO_EXCEPTION) exit(-1);

   name3->sompInitNearObject (ev, mylist);
   if (ev->_major != NO_EXCEPTION) exit(-1);

/* Get the object id used for storing the directory.
   ------------------------------------------------- */
   pid = mylist->sompGetPersistentId (ev);
   fp  = pid->sompGetIOGroupName (ev, idBuff);

/* Store the phone directory.
   -------------------------- */
   psm->sompStoreObject(ev, mylist);
   if (ev->_major != NO_EXCEPTION) exit(-1);

/* Finished.
   --------- */
   delete name1;
   delete name2;
   delete name3;
   delete mylist;
}

/*
--------------------------------------------------------------------
modify
Restores a (previously created) persistent object, adds and
updates entries, and stores the (modified) object.
--------------------------------------------------------------------
*/
void modify()
{
/* Local declarations.
   ------------------- */
   dirEntry  *newname, *oldname;
   phoneDir  *mylist;
   SOMPPersistentId *pid;

/* Set Id of Persistent Object to be restored.
   ------------------------------------------- */
   pid = new SOMPPersistentId;             /*  Free before exit */
   pid->sompSetIOGroupName(ev, idBuff);
   if (ev->_major != NO_EXCEPTION) {
      printf ("Set Persistent Name failed.\n");
      exit(-1);
   }

/* Restore phone directory.
   ------------------------ */
   mylist = (phoneDir*)psm->sompRestoreObject (ev, pid);
   if (ev->_major != NO_EXCEPTION) exit(-1);

/* Add a new entry to the directory.
   --------------------------------- */
   newname = new dirEntry;
   newname->sompInitNearObject (ev, mylist);
   if (ev->_major != NO_EXCEPTION) exit(-1);

   newname->mkEntry ("Robert", "555-5158");
   mylist->addEntry (newname);

/* Modify an existing Entry.
   ------------------------- */
   oldname = mylist->getEntry ("Charles");
   if (oldname == (dirEntry *) NULL) {
     printf ("\nCould not find entry for Charles\n");
   } else {
     oldname->mkEntry ("Charles", "555-5071");
     oldname->sompSetState (ev, SOMP_STATE_DIRTY);
   } /* endif */

/* Display the modified phone directory.
   ------------------------------------- */
   mylist->printDirInfo();

/* Store the modified phone directory.
   ----------------------------------- */
   psm->sompStoreObject (ev, mylist);
   if (ev->_major != NO_EXCEPTION) exit(-1);

/* Finished.
   --------- */
   delete pid;
   delete newname;
   delete oldname;
   delete mylist;
}

/*
--------------------------------------------------------------------
deletepo
Demonstrates deleting a persistent object from its I/O group.
--------------------------------------------------------------------
*/
void deletepo()
{
/* Local declarations.
   ------------------- */
   dirEntry  *dropname;
   phoneDir  *mylist;
   char deleteBuff[100];
   SOMPPersistentId *pid, *dropPid;
   string fp;

/* Set Id of Persistent Object to be restored.
   ------------------------------------------- */
   pid = new SOMPPersistentId;
   pid->sompSetIOGroupName(ev, idBuff);
   if (ev->_major != NO_EXCEPTION) {
      printf ("Set Persistent Name failed.\n");
      exit(-1);
   }

/* Restore phone directory.
   ------------------------ */
   mylist = (phoneDir*)psm->sompRestoreObject (ev, pid);
   if (ev->_major != NO_EXCEPTION) exit(-1);

/* Delete one of the entries.
   -------------------------- */
   dropname = mylist->dropEntry ("Hari");

/* Get and display the persistent id for the entry.
   ------------------------------------------------ */
   dropPid = dropname->sompGetPersistentId (ev);

/* Delete the persistent object from the I/O group.
   ------------------------------------------------ */
   psm->sompDeleteObject(ev, dropPid);
   if (ev->_major != NO_EXCEPTION) exit(-1);

/* Store the modified phone directory.
   ----------------------------------- */
   psm->sompStoreObject (ev, mylist);

/* Display the directory.
   ---------------------- */
   mylist->printDirInfo();

/* Finished.
   --------- */
   delete pid;
   delete mylist;
}

/*
--------------------------------------------------------------------
restore
Demonstrates restoration of a persistent object.
--------------------------------------------------------------------
*/
void restore()
{
/* Local declarations.
   ------------------- */
   phoneDir  *mylist;
   SOMPPersistentId *pid;

/* Set Id of Persistent Object to be restored.
   ------------------------------------------- */
   pid = new SOMPPersistentId;           /*  Free before exit */
   pid->sompSetIOGroupName(ev, idBuff);
   if (ev->_major != NO_EXCEPTION) {
      printf ("Set Persistent Name failed.\n");
      exit(-1);
   }

/* Restore phone directory.
   ------------------------ */
   mylist = (phoneDir*)psm->sompRestoreObject (ev, pid);
   if (ev->_major != NO_EXCEPTION) exit(-1);

/* Display the directory.
   ---------------------- */
   mylist->printDirInfo();

/* Finished.
   --------- */
   delete pid;
}

main()
{
/* Initialize the Persistence Framework.
   ------------------------------------- */
   psm = new SOMPPersistentStorageMgr;
   idAssigner = new SOMPIdAssigner;
   ev = somGetGlobalEnvironment();
   dirEntryNewClass(0,0);
   phoneDirNewClass(0,0);

   printf("\nSave test\n");
   save();
   printf("\nModify test\n");
   modify();
   printf("\nDelete test\n");
   deletepo();
   printf("\nRestore test\n");
   restore();
   delete (idAssigner);
   exit (0);
}

